<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var app\models\Product $product */
/** @var app\models\Cart $cartItem */
$this->title = $product->name;
$this->params['breadcrumbs'][] = ['label' => 'Каталог', 'url' => ['product/index']];
$this->params['breadcrumbs'][] = ['label' => $product->category->name ?? 'Без категории', 'url' => ['product/index', 'category' => $product->category_id]];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="product-view">
    <div class="row">
        <!-- Изображение -->
        <div class="col-md-6">
            <div class="product-image mb-4">
                <?= Html::img("@web/images/{$product->image}", [
                    'class' => 'img-fluid rounded-start',
                    'alt' => $product->name,
                    'style' => 'max-height: 150px; object-fit: cover;'
                ]) ?>
            </div>
        </div>
        <div class="col-md-6">
            <h1 class="product-title"><?= Html::encode($product->name) ?></h1>

            <div class="product-meta mb-3">
                <?php if ($product->category): ?>
                    <span class="badge bg-secondary"><?= Html::encode($product->category->name) ?></span>
                <?php endif; ?>
                <?php if ($product->counts > 0): ?>
                    <span class="badge bg-success ms-2">В наличии</span>
                <?php else: ?>
                    <span class="badge bg-danger ms-2">Нет в наличии</span>
                <?php endif; ?>
            </div>

            <div class="product-price mb-4">
                <h2 class="text-primary"><?= $product->price ?> ₽</h2>
            </div>

            <!-- Форма добавления в корзину -->
            <?php if ($product->counts > 0): ?>
                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="card-title">Добавить в корзину</h5>
                        <?php $form = ActiveForm::begin([
                            'action' => ['cart/add'],
                            'method' => 'post',
                            'options' => ['class' => 'add-to-cart-form']
                        ]); ?>

                        <?= Html::hiddenInput('product_id', $product->id) ?>

                        <div class="row align-items-end">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <?= Html::label('Количество', 'quantity', ['class' => 'form-label']) ?>
                                    <?= Html::input('number', 'quantity', $cartItem->quantity ?? 1, [
                                        'class' => 'form-control',
                                        'id' => 'quantity',
                                        'min' => 1,
                                        'max' => $product->counts,
                                        'required' => true
                                    ]) ?>
                                    <small class="text-muted">Доступно: <?= $product->counts ?> шт.</small>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <?= Html::submitButton('Добавить в корзину', [
                                    'class' => 'btn btn-primary btn-lg w-100'
                                ]) ?>
                            </div>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Описание</h5>
                </div>
                <div class="card-body">
                    <div class="product-description">
                        <?= nl2br(Html::encode($product->description)) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if ($similarProducts): ?>
        <div class="mt-5">
            <h3>Похожие товары</h3>
            <div class="row mt-3">
                <?php foreach ($similarProducts as $similar): ?>
                    <div class="col-md-3 col-sm-6 mb-4">
                        <div class="card h-100">
                            <?= Html::a(
                                Html::img($similar->image, [
                                    'class' => 'card-img-top',
                                    'alt' => $similar->name,
                                    'style' => 'height: 200px; object-fit: cover;'
                                ]),
                                ['product/view', 'id' => $similar->id],
                                ['class' => 'text-decoration-none']
                            ) ?>
                            <div class="card-body">
                                <h5 class="card-title">
                                    <?= Html::a(Html::encode($similar->name),
                                        ['product/view', 'id' => $similar->id],
                                        ['class' => 'text-decoration-none text-dark']
                                    ) ?>
                                </h5>
                                <p class="card-text text-primary fw-bold">
                                    <?= $similar->price ?> ₽
                                </p>
                                <?php if ($similar->counts > 0): ?>
                                    <?= Html::a('В корзину', ['cart/add', 'product_id' => $similar->id], [
                                        'class' => 'btn btn-outline-primary btn-sm'
                                    ]) ?>
                                <?php else: ?>
                                    <span class="text-muted">Нет в наличии</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>