<?php
use yii\helpers\Url;
use yii\helpers\Html;

/** @var app\models\Product $model */
?>
<div class="card h-100">
    <?= Html::a(
        Html::img("@web/images/{$model->image}", [
            'class' => 'card-img-top',
            'alt' => $model->name,
            'style' => 'height: 200px; object-fit: cover;'
        ]),
        ['product/view', 'id' => $model->id],
        ['class' => 'text-decoration-none']
    ) ?>
    <div class="card-body d-flex flex-column">
        <h5 class="card-title">
            <?= Html::a(Html::encode($model->name),
                ['product/view', 'id' => $model->id],
                ['class' => 'text-decoration-none text-dark']
            ) ?>
        </h5>
        <?php if ($model->category): ?>
            <p class="card-text">
                <small class="text-muted"><?= Html::encode($model->category->name) ?></small>
            </p>
        <?php endif; ?>
        <p class="card-text flex-grow-1">
            <?= \yii\helpers\StringHelper::truncate($model->description, 100, '...') ?>
        </p>
        <div class="mt-auto">
            <p class="card-text text-primary fw-bold">
                <?= $model->price ?> ₽
            </p>
            <div class="d-flex justify-content-between align-items-center">
                <?php if ($model->counts > 0): ?>
                    <?= Html::a('В корзину', ['cart/add', 'id' => $model->id], [
                        'class' => 'btn btn-primary'
                    ]) ?>
                <?php else: ?>
                    <span class="text-muted">Нет в наличии</span>
                <?php endif; ?>
                <span class="badge bg-info"><?= $model->counts ?> шт.</span>
            </div>
        </div>
    </div>
</div>