<?php
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Order $order */
$this->title = 'Заказ №' . $order->id;
$this->params['breadcrumbs'][] = ['label' => 'Мои заказы', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="order-view">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= Yii::$app->session->getFlash('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Товары в заказе</h5>
                </div>
                <div class="card-body">
                    <?php if (empty($order->orderItems)): ?>
                        <div class="alert alert-warning">
                            В заказе нет товаров.
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                <tr>
                                    <th>Товар</th>
                                    <th>Количество</th>
                                    <th>Цена за шт.</th>
                                    <th>Сумма</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($order->orderItems as $item): ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?= Html::img("@web/images/{$item->product->image}", [
                                                    'class' => 'img-fluid rounded-start',
                                                    'alt' => $item->product->name,
                                                    'style' => 'max-height: 150px; object-fit: cover;'
                                                ]) ?>
                                                <span><?= Html::encode($item->product->name) ?></span>
                                            </div>
                                        </td>
                                        <td><?= $item->quantity ?> шт.</td>
                                        <td><?= $item->price_per_item ?> ₽</td>
                                        <td><?= $item->quantity * $item->price_per_item ?> ₽</td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                <tr class="table-active">
                                    <td colspan="3" class="text-end fw-bold">Итого:</td>
                                    <td class="fw-bold"><?= $order->total_price ?> ₽</td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Информация о заказе</h5>
                </div>
                <div class="card-body">
                    <?= DetailView::widget([
                        'model' => $order,
                        'attributes' => [
                            [
                                'attribute' => 'id',
                                'label' => 'Номер заказа'
                            ],
                            [
                                'attribute' => 'status',
                                'format' => 'raw',
                                'value' => function($model) {
                                    $statusClass = [
                                        'Новый' => 'badge bg-primary',
                                        'Подтверждён' => 'badge bg-success',
                                        'В процессе' => 'badge bg-info',
                                        'Доставлен' => 'badge bg-secondary',
                                        'Отменён' => 'badge bg-danger'
                                    ];

                                    $class = $statusClass[$model->status] ?? 'badge bg-secondary';
                                    return Html::tag('span', $model->displayStatus(), ['class' => $class]);
                                }
                            ],
                            [
                                'attribute' => 'total_price',
                                'value' => $order->total_price . ' ₽',
                                'label' => 'Сумма заказа'
                            ],
                            [
                                'attribute' => 'payment_method',
                                'value' => $order->displayPaymentMethod(),
                                'label' => 'Способ оплаты'
                            ],
                            [
                                'attribute' => 'delivery_method',
                                'value' => $order->displayDeliveryMethod(),
                                'label' => 'Способ доставки'
                            ],
                            [
                                'attribute' => 'created_at',
                                'format' => ['datetime', 'php:d.m.Y H:i'],
                                'label' => 'Дата оформления'
                            ],
                        ],
                    ]) ?>
                </div>
            </div>

            <?php if ($order->delivery_method === $order::DELIVERY_METHOD_COURIER): ?>
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Данные доставки</h5>
                    </div>
                    <div class="card-body">
                        <?= DetailView::widget([
                            'model' => $order,
                            'attributes' => [
                                [
                                    'attribute' => 'delivery_address',
                                    'label' => 'Адрес доставки'
                                ],
                                [
                                    'attribute' => 'delivery_interval',
                                    'label' => 'Время доставки'
                                ],
                            ],
                        ]) ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Действия</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <?php if ($order->canBeCancelled()): ?>
                            <?= Html::a('Отменить заказ', ['cancel', 'id' => $order->id], [
                                'class' => 'btn btn-danger',
                                'data' => [
                                    'confirm' => 'Вы уверены, что хотите отменить этот заказ?',
                                    'method' => 'post',
                                ],
                            ]) ?>
                        <?php endif; ?>

                        <?= Html::a('Повторить заказ', ['cart/repeat-order', 'id' => $order->id], [
                            'class' => 'btn btn-outline-primary',
                        ]) ?>

                        <?= Html::a('Вернуться к заказам', ['index'], [
                            'class' => 'btn btn-outline-secondary',
                        ]) ?>

                        <?= Html::a('Продолжить покупки', ['product/index'], [
                            'class' => 'btn btn-outline-success',
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>