<?php
use yii\helpers\Html;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var yii\data\ActiveDataProvider $dataProvider */
$this->title = 'Мои заказы';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="order-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= Yii::$app->session->getFlash('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if ($dataProvider->getTotalCount() > 0): ?>
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'tableOptions' => ['class' => 'table table-hover'],
            'columns' => [
                [
                    'attribute' => 'id',
                    'header' => '№ заказа',
                    'contentOptions' => ['style' => 'width: 100px;']
                ],
                [
                    'attribute' => 'total_price',
                    'value' => function($model) {
                        return $model->total_price . ' ₽';
                    },
                    'header' => 'Сумма'
                ],
                [
                    'attribute' => 'payment_method',
                    'value' => function($model) {
                        return $model->displayPaymentMethod();
                    },
                    'header' => 'Оплата'
                ],
                [
                    'attribute' => 'delivery_method',
                    'value' => function($model) {
                        return $model->displayDeliveryMethod();
                    },
                    'header' => 'Доставка'
                ],
                [
                    'attribute' => 'status',
                    'format' => 'raw',
                    'value' => function($model) {
                        $statusClass = [
                            'Новый' => 'badge bg-primary',
                            'Подтверждён' => 'badge bg-success',
                            'В процессе' => 'badge bg-info',
                            'Доставлен' => 'badge bg-secondary',
                            'Отменён' => 'badge bg-danger'
                        ];

                        $class = $statusClass[$model->status] ?? 'badge bg-secondary';
                        return Html::tag('span', $model->displayStatus(), ['class' => $class]);
                    },
                    'header' => 'Статус'
                ],
                [
                    'attribute' => 'created_at',
                    'format' => ['datetime', 'php:d.m.Y H:i'],
                    'header' => 'Дата'
                ],
                [
                    'class' => 'yii\grid\ActionColumn',
                    'template' => '{view}',
                    'buttons' => [
                        'view' => function($url, $model) {
                            return Html::a('Подробнее', $url, [
                                'class' => 'btn btn-sm btn-primary'
                            ]);
                        }
                    ],
                    'contentOptions' => ['style' => 'width: 120px; text-align: center;']
                ],
            ],
        ]); ?>
    <?php else: ?>
        <div class="alert alert-info">
            У вас еще нет заказов. <a href="<?= \yii\helpers\Url::to(['product/index']) ?>">Начать покупки</a>
        </div>
    <?php endif; ?>
</div>