<?php
use yii\helpers\Url;
use yii\helpers\Html;

/** @var app\models\Order $model */
?>
<div class="card mb-3">
    <div class="card-header">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h5 class="mb-0">Заказ №<?= $model->id ?></h5>
                <small class="text-muted"><?= Yii::$app->formatter->asDatetime($model->created_at) ?></small>
            </div>
            <div>
                <span class="badge bg-<?= $model->statusColor ?>"><?= $model->displayStatus() ?></span>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-8">
                <h6>Товары:</h6>
                <ul class="list-unstyled">
                    <?php foreach ($model->orderItems as $item): ?>
                        <li class="mb-1">
                            <?= Html::encode($item->product->name) ?> × <?= $item->quantity ?>
                            <span class="text-muted">(<?= $item->price_per_item ?> ₽/шт.)</span>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <div class="col-md-4">
                <div class="order-summary">
                    <p><strong>Способ оплаты:</strong> <?= $model->displayPaymentMethod() ?></p>
                    <p><strong>Способ доставки:</strong> <?= $model->displayDeliveryMethod() ?></p>
                    <?php if ($model->delivery_address): ?>
                        <p><strong>Адрес:</strong> <?= Html::encode($model->delivery_address) ?></p>
                    <?php endif; ?>
                    <?php if ($model->delivery_interval): ?>
                        <p><strong>Интервал:</strong> <?= Html::encode($model->delivery_interval) ?></p>
                    <?php endif; ?>
                    <p class="fw-bold fs-5">Итого: <?= $model->total_price ?> ₽</p>
                </div>
            </div>
        </div>

        <div class="mt-3">
            <?= Html::a('Повторить заказ', ['cart/repeat-order', 'id' => $model->id], [
                'class' => 'btn btn-outline-primary btn-sm'
            ]) ?>
            <?= Html::a('Подробнее', ['order/view', 'id' => $model->id], [
                'class' => 'btn btn-outline-secondary btn-sm ms-2'
            ]) ?>
        </div>
    </div>
</div>