<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var app\models\Cart[] $cartItems */
/** @var float $totalPrice */
$this->title = 'Корзина';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="cart-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if (empty($cartItems)): ?>
        <div class="alert alert-info">
            Ваша корзина пуста. <a href="<?= Url::to(['product/index']) ?>">Перейти к покупкам</a>
        </div>
    <?php else: ?>
        <div class="row">
            <div class="col-md-8">
                <div class="cart-items">
                    <?php foreach ($cartItems as $item): ?>
                        <div class="cart-item card mb-3">
                            <div class="row g-0">
                                <div class="col-md-3">
                                    <?= Html::img("@web/images/{$item->product->image}", [
                                        'class' => 'img-fluid rounded-start',
                                        'alt' => $item->product->name,
                                        'style' => 'max-height: 150px; object-fit: cover;'
                                    ]) ?>
                                </div>
                                <div class="col-md-9">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div>
                                                <h5 class="card-title"><?= Html::encode($item->product->name) ?></h5>
                                                <p class="card-text">
                                                    <small class="text-muted">Цена: <?= $item->product->price ?> ₽</small>
                                                </p>
                                            </div>
                                            <div>
                                                <?php $form = ActiveForm::begin([
                                                    'action' => ['cart/update'],
                                                    'method' => 'post',
                                                    'options' => ['class' => 'd-inline']
                                                ]); ?>
                                                <?= Html::hiddenInput('id', $item->id) ?>
                                                <div class="input-group" style="width: 150px;">
                                                    <?= Html::input('number', 'quantity', $item->quantity, [
                                                        'class' => 'form-control',
                                                        'min' => 1,
                                                        'max' => $item->product->counts
                                                    ]) ?>
                                                    <button class="btn btn-outline-secondary" type="submit">
                                                        <i class="bi bi-arrow-clockwise"></i>
                                                    </button>
                                                </div>
                                                <?php ActiveForm::end(); ?>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center mt-2">
                                            <span class="fw-bold">
                                                Итого: <?= $item->quantity * $item->product->price ?> ₽
                                            </span>
                                            <?= Html::a('Удалить', ['cart/delete', 'id' => $item->id], [
                                                'class' => 'btn btn-danger btn-sm',
                                                'data' => [
                                                    'confirm' => 'Вы уверены, что хотите удалить товар из корзины?',
                                                    'method' => 'post',
                                                ],
                                            ]) ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Итоги заказа</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Товары:</span>
                            <span><?= $totalPrice ?> ₽</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Доставка:</span>
                            <span>Рассчитывается при оформлении</span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between fw-bold fs-5">
                            <span>Итого:</span>
                            <span><?= $totalPrice ?> ₽</span>
                        </div>
                        <div class="mt-3">
                            <?= Html::a('Оформить заказ', ['order/create'], [
                                'class' => 'btn btn-success w-100 btn-lg'
                            ]) ?>
                            <?= Html::a('Продолжить покупки', ['product/index'], [
                                'class' => 'btn btn-outline-primary w-100 mt-2'
                            ]) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>