<?php

namespace app\models;

use yii\base\Model;

class SignupForm extends Model
{
    public $surname;
    public $name;
    public $patronymic;
    public $phone_number;
    public $email;
    public $password;
    public $password_repeat;

    public function rules()
    {
        return [
            [['surname', 'name', 'phone_number', 'email', 'password'], 'required'],
            [['phone_number'], 'unique', 'targetClass' => User::class],
            [['surname', 'name', 'patronymic'], 'match', 'pattern' => '/^[а-яА-ЯёЁ\s\-]+$/u', 'message' => 'Можно использовать только символы русского алфавита, пробел, тире'],
            ['phone_number', 'match', 'pattern' => '/^\+7\(\d{3}\)-\d{3}-\d{2}-\d{2}$/',  'message' => 'Неверный формат номера телефона'],
            ['password', 'string', 'min' => 6],
            ['email', 'email'],
            ['password_repeat', 'compare', 'compareAttribute' => 'password']
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'surname' => 'Фамилия',
            'name' => 'Имя',
            'patronymic' => 'Отчество',
            'phone_number' => 'Номер телефона',
            'email' => 'Email',
            'password' => 'Пароль',
            'password_repeat' => 'Повтор пароля',
        ];
    }

    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }

        $user = new User();
        $user->surname = $this->surname;
        $user->name = $this->name;
        $user->patronymic = $this->patronymic;
        $user->phone_number = $this->phone_number;
        $user->email = $this->email;
        $user->setPassword($this->password);

        return $user->save() ? $user : null;
    }
}