<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;

class OrderSearch extends Order
{
    public function rules()
    {
        return [
            [['id', 'user_id', 'total_price'], 'integer'],
            [['payment_method', 'delivery_method', 'status', 'created_at'], 'safe'],
        ];
    }

    public function search($params)
    {
        $query = Order::find()->with('user');

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => ['created_at' => SORT_DESC],
            ],
            'pagination' => [
                'pageSize' => 20,
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'user_id' => $this->user_id,
            'total_price' => $this->total_price,
            'status' => $this->status,
        ]);

        $query->andFilterWhere(['like', 'payment_method', $this->payment_method])
            ->andFilterWhere(['like', 'delivery_method', $this->delivery_method]);

        if ($this->created_at) {
            $query->andFilterWhere(['>=', 'created_at', date('Y-m-d 00:00:00', strtotime($this->created_at))])
                ->andFilterWhere(['<=', 'created_at', date('Y-m-d 23:59:59', strtotime($this->created_at))]);
        }

        return $dataProvider;
    }
}